/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProject;
import org.compiere.model.MProjectType;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class ProjectSetType
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_C_ProjectType_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_ProjectType_ID")) {
                    this.m_C_ProjectType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MProject project;
        this.m_C_Project_ID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - C_Project_ID=" + this.m_C_Project_ID + ", C_ProjectType_ID=" + this.m_C_ProjectType_ID);
        }
        if ((project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName())).getC_Project_ID() == 0 || project.getC_Project_ID() != this.m_C_Project_ID) {
            throw new IllegalArgumentException("Project not found C_Project_ID=" + this.m_C_Project_ID);
        }
        if (project.getC_ProjectType_ID() > 0) {
            throw new IllegalArgumentException("Project already has Type (Cannot overwrite) " + project.getC_ProjectType_ID());
        }
        MProjectType type = new MProjectType(this.getCtx(), this.m_C_ProjectType_ID, this.get_TrxName());
        if (type.getC_ProjectType_ID() == 0 || type.getC_ProjectType_ID() != this.m_C_ProjectType_ID) {
            throw new IllegalArgumentException("Project Type not found C_ProjectType_ID=" + this.m_C_ProjectType_ID);
        }
        project.setProjectType(type);
        if (!project.save()) {
            throw new Exception("@Error@");
        }
        return "@OK@";
    }
}

